﻿
# Transformation bounce (sautillement)
transform bounce:
    yoffset 0
    linear 0.1 yoffset -10
    linear 0.1 yoffset 0


# Callback générique, lié à un tag par personnage
init python:
    def make_bounce_callback(tag):
        def bounce_talk(event, interact=True, **kwargs):
            if event == "begin" and renpy.showing(tag):
                renpy.show(tag, at_list=[bounce])
        return bounce_talk

define config.main_menu_music = "audio/1.mp3"

# Déclarez les personnages utilisés dans le jeu.
define p = Character('[PlayerName]', color="#c8ffc8", image = "player1")
define i = Character('Interne', color="#a2eaa2", image = "narrateur1")
define e = Character('Genoveva', color="#a8c9ff",  callback=make_bounce_callback("genoveva"))
define g = Character('Galeazzo', color="#c97474", callback=make_bounce_callback("galeazzo"))
define a = Character('anteo', color="#e0cfa6",  callback=make_bounce_callback("anteo"))
define m = Character('marius', color="#b199ff", callback=make_bounce_callback("marius"))
define s = Character('sante', color="#9bc4a8", callback=make_bounce_callback("sante"))
define r = Character("roger", color="#b7b7b7", callback=make_bounce_callback("roger"))
define u = Character("unity", color="#ffa87c", callback=make_bounce_callback("unity"))
define o = Character("Gasparri", color="#dcb8ff", callback=make_bounce_callback("Gasparri"))
define n = Character("gentile", color="#d6d89b", callback=make_bounce_callback("gentile"))
define z = Character("Savitri", color="#ffb5c4", callback=make_bounce_callback("Savitri"))
define b = Character("eleve", color="#b0c4c4", callback=make_bounce_callback("eleve"))



# Déclaration des sprites regroupés par TAG
image genoveva neutral = "images/char/Genoveva/SANS BG/ge4.png"
image genoveva neutral2 = "images/char/Genoveva/SANS BG/ge5.png"
image genoveva neutral3 = "images/char/Genoveva/SANS BG/ge6.png"
image genoveva neutral4 = "images/char/Genoveva/SANS BG/ge7.png"
image genoveva neutral5 = "images/char/Genoveva/SANS BG/ge8.png"
image genoveva neutral6 = "images/char/Genoveva/SANS BG/ge10.png"
image genoveva neutral7 = "images/char/Genoveva/SANS BG/ge9.png"
image genoveva angry = "images/char/Genoveva/SANS BG/ge2.png"
image genoveva smile = "images/char/Genoveva/SANS BG/ge3.png"
image genoveva lundimatin = "images/char/Genoveva/SANS BG/ge11.png"
image genoveva chokbarre = "images/char/Genoveva/SANS BG/ge12.png"
###################################################################
image side narrateur1 = "images/char/narrateur/SANS BG/na1.png"
image side player1 = "images/char/player/SANS BG/pla1.png"
###################################################################
image marius neutral = "images/char/marius/SANS BG/ma1.png"
image marius happy = "images/char/marius/SANS BG/ma4.png"
image marius surprised = "images/char/marius/SANS BG/ma5.png"
image marius smirk = "images/char/marius/SANS BG/ma6.png"
###################################################################
image anteo neutral = "images/char/anteo/SANS BG/an1.png"
image anteo annoyed = "images/char/anteo/SANS BG/an3.png"
##################################################################
image sante neutral = "images/char/sante/SANS BG/sa1.png"
##################################################################
image roger neutral = "images/char/roger/SANS BG/ro1.png"
image roger annoyed = "images/char/roger/SANS BG/ro2.png"
image roger suspicious = "images/char/roger/SANS BG/ro3.png"
##################################################################
image unity neutral = "images/char/unity/SANS BG/un1.png"
##################################################################
image galeazzo neutral = "images/char/Galeazzo/SANS BG/ga1.png"
image galeazzo angry = "images/char/Galeazzo/SANS BG/ga2.png"
#################################################################
image Gasparri neutral = "images/char/aumonier/SANS BG/am1.png"
#################################################################
image gentile neutral = "images/char/gentile/SANS BG/gg1.png"



#variable utiliser
default scoredocile = 0
default scoremuet = 0
default scoredefiant = 0
default scoretimide = 0
default scoreaudacieux = 0
default scoreblame = 0
default promesse1 = 0

###############################
screen screen_language:
    imagemap:
        ground "images/bg/black.png"
        hover "images/bg/black.png"

        imagebutton:
            idle "images/GUI/english_idle.png"
            hover "images/GUI/english_hover.png"
            pos (650,300)
            action Language(None),Return()

        imagebutton:
            idle "images/GUI/french_idle.png"
            hover "images/GUI/french_hover.png"
            pos (350,300)
            action Language("french"),Return()
###############################
# Au lancement du jeu
label splashscreen:
    call screen screen_language
    return
###############################
# Le jeu commence ici
label start:
    play music "audio/4.mp3"
    #Affichage logo CPL
    window hide 
    scene bg copyleft
    $ renpy.pause(3)
    scene black
    window hide 

    # Chapitre 1
    # Acte 1
    # Scène 1 (carton)
    scene black with fade
    centered "This story is fiction.\n\nIf you recognize any of the characters or situations,\n\n then you are probably a fictional character yourself."
    $ renpy.pause(6)
    scene black
    "Perhaps to have been useful"
    "It's a modest and crazy dream"
    "It would have been better to keep quiet about it"
    "You will bury me with it"
    scene bg deathbyexplod
    "Like a star at the bottom of a hole"
    window hide 

    scene bg dimanche
    centered "{size=+50}{b}SUNDAY\n\nMUD{/b}{/size}"


    pause 

    # Acte 4
    # Scène 1 (carton/interne)
    scene bg base
    "Citizen Training Center "
    "Austere, grey, soulless — a building standing like a scar in the middle of a suffocated landscape."
    "Seventeen years since the beginning of the Special Peace Operation. Seventeen years of propaganda, forced oaths, broken families."
    i "Here, they didn’t just train citizens. They molded instruments — interchangeable, obedient, ready to erase themselves for the Nation."

    # Acte 5
    # Scène 1 (interne/Galeazzo/Player)
    scene bg bureau
    i "The voice inviting me in was neither friendly nor compassionate. It cut through the air — cold, almost metallic."
    i "The director didn’t look at me, too busy reading a file that already seemed to seal my fate."
    i "I stepped closer to the desk, but there was no chair on my side. Only the director sat — master of his space, like a judge upon his stand."
    i "I waited standing… like an idiot. Seconds stretched out, each tick of the clock echoing like a hammer strike."
    i "How can he work with that noise? The director’s office isn’t just a workplace: it’s a courtroom. Bare walls, drawn curtains, dust carefully wiped away… everything reeked of severity."
    i "At least, that’s the impression the decor gives. A gilded cage for those who hold power."
    show galeazzo neutral
    g "\"You are now a cadet of this school. But don’t be mistaken… your place here is not guaranteed.\""
    i "Great. I haven’t even unpacked yet and I’m already on probation. As if even my breathing needed approval."
    g "Normally, we don’t accept students in the middle of the year. But given the circumstances, we’ll make an exception."
    g "Consider your presence here a privilege. Young people your age are sent to the front every day, to defend the peace our Nation offers the world."
    i "A privilege. That’s what I am — a tolerated burden, a random cog in the machine."
    g "Good. What is your name, cadet?"
    #$ PlayerName = renpy.input("What is your name?", "", length=15, exclude=" 0123456789+=,.?!<>{}[]()").strip() or "Ravachol"
    $ PlayerName = renpy.input(_("What is your name?"), default="", length=15, exclude="0123456789+=,.?!<>{}[]()").strip() or "Ravachol"


    menu:
        "\[OBEDIENT\] \"[PlayerName], sir\"":
            i "I was about to speak, but before I could even open my mouth, he answered his own question — as if my existence didn’t matter."
            jump prenom



        "\[MISTRUSTFUL\] \"Are you talking to me? Or to your file ?\"":
            i "I was about to speak, but before I could say a word, he answered his own question. Maybe he prefers talking to his papers rather than to me."
            jump prenom

label prenom:
    g "Cadet [PlayerName]."
    i "He finally lifted his eyes from the file, revealing a cold, strict gaze. His pupils seemed to probe my soul — or perhaps just measure my usefulness."
    g "You’re fortunate to be here. To receive an education. To become a useful tool rather than an anonymous sacrifice."
    i "\"Fortunate,\" huh... Yeah, sure — thrilled to be shaped into a tool instead of being turned to dust on the front line. Cheers to that."
    i "His words fell like stones — heavy, devoid of warmth. Humanity was only a secondary variable here."


    menu:
        "\[OBEDIENT\] \"I’m aware of my privilege, sir. I won’t waste it.\"":
            jump Docile



        "\[MISTRUSTFUL\] \"I’m not sure we can really call it luck…\"":
            jump rebelle

label Docile :
    $ scoredocile += 1
    p "\"I’m aware of my privilege, sir. I won’t waste it.\""
    i "There. That’s what he likes. The ready-made phrases. The good old submission. What a moron"
    g "We’ll see. But for your sake, I hope so."
    i "He sizes me up like a merchant inspecting his goods. A smile would’ve been too much to ask."
    jump docilesmuetsilence



label rebelle :
    $ scoredefiant += 1
    p "\"I’m not sure we can really call it luck…\""
    i "Suddenly, his stern expression shifted into one of disdain — sharp, filled with spite."
    g "That attitude will get you nowhere. Think of your mother, and don’t be ungrateful."
    i "Son of a bitch. He dares mention my mother. He knows my situation and uses it against me — an invisible weapon, but a sharp one."
    i "My fist tightens. Yet I stay still, trapped in this office that smells of wax and cold dust."

    menu:
        "\[SPEECHLESS] \"…\"":
            jump docilesmuetsilence

        "\[MUTE] \"…\"":
            jump docilesmuetsilence

        "\[STUNNED] \"…\"":
            jump docilesmuetsilence

label docilesmuetsilence :

    i "He dives back into the file and starts reading aloud, each syllable dropping like a verdict."
    g "\"Name: [PlayerName]. Background: … troubling. You’re not entering here as a blank page.\""
    i "Ah, my famous file — the official summary of 'who I am', regime version. I just hope they used a picture where I look halfway decent."
    i "The truth? That paper says nothing about me. But to him, it’s more real than my own flesh."
    g "Before we proceed, I’d like to clarify a point in your file."
    i "The tone changed — slower, almost curious. Like a snake tasting the air before striking."
    g "You come from Chorath Colony, correct?"
    p "Yes, sir."
    g "Your father held an... important position there."
    i "The word drags, tinged with suspicion. He waits for a reaction, but I give him none."
    g "And he... took his own life. Is that correct?"
    i "A silence. Long enough to make the air tremble."
    p "That’s what the report says."
    g "What the report says?"
    i "I shrug slightly. He wants to make me talk, but words have barbed wire."
    p "I wasn’t there. They just told me it was... inevitable."
    g "Inevitable. Interesting choice of word."
    i "I can feel his gaze pressing on me, searching for what I won’t say."
    g "The reasons for his act are... unclear. You know, here, we value clarity."
    i "Clarity? He wants me to say what everyone already whispers?"
    p "My father... didn’t agree with certain rules. He preferred to silence himself permanently rather than be silenced."
    i "There. Said it. Not all of it, just enough for him to understand."
    g "I see. You bear a... complex legacy. I hope you’ll manage to straighten it."
    i "Straighten — like a bent rod. Or a defiant cadet."
    g "We don’t judge the sins of the fathers here. Only those of the sons."
    i "Lies. Here, every legacy is just a disguised sentence."
    i "He closes the file with a sharp motion. The conversation is over, but the weight remains — clinging to my skin like a damp shadow."
    g "Here, you will learn three things: discipline, obedience, sacrifice. Without them, you are nothing."
    i "Three magic words. It almost sounds like an advertising slogan — except here, the product is me."
    i "Discipline, obedience, sacrifice... polished chains you’re expected to wear with a smile."

    menu:
        "\[OBEDIENT] \"I understand. I’ll follow those rules.\"":
            jump docile2

        "\[MISTRUSTFUL] \"Three words… yet none of them speak of thinking for oneself.\"":
            jump defiant2

label docile2 :
    $ scoredocile += 1
    p "\"I understand. I’ll follow those rules.\""
    i "And I’ll eat my vegetables and go to bed early, too — promise."
    g "You seem to understand what is expected of you. Good."
    jump docilemuetdefiant2



label defiant2 :
    $ scoredefiant += 1
    g "\"Thinking is a privilege reserved for superiors. Not for you.\""
    i "Great — guess I can put my brain in storage, then. Lovely atmosphere."
    i "And there it is — the man just said aloud what the regime whispers in private."
    jump docilemuetdefiant2

label docilemuetdefiant2 :
    g "You are here by tolerance, not by merit. Your presence is a test. If you fail… the Council will prove me right for refusing you."
    i "His tone was sharp, merciless. Every word served to remind me that I was nothing more than an unwanted guest."

    menu:
        "\[OBEDIENT] \"I’ll prove you weren’t mistaken about me.\"":
            jump docile3



        "\[MISTRUSTFUL] \"The Council was right. You’ll see.\"":
            jump defiant3
label docile3 :
    $ scoredocile += 1
    p "\"I’ll prove you weren’t mistaken about me.\""
    i "If it keeps him quiet, I can play the model student for now."
    g "A sensible answer. Now it’s up to you to live by it."
    jump docilemuetdefiant3



label defiant3 :
    $ scoredefiant += 1
    p "\"The Council was right. You’ll see.\""
    i "Brilliant, me — that’s how to make yourself hated in under three seconds flat."
    g "Insolence is a weakness. Here, it won’t save you."
    jump docilemuetdefiant3

label docilemuetdefiant3 :
    i "A heavy silence follows. The director slides my file into a drawer, stands up, circles the desk, and approaches — his steps echoing on the polished floor."
    g "You think you’re special. But here, you will be broken… or forged. There is no alternative."

    if scoredefiant >= 3:
        jump defiant4

    elif scoredocile >= 3:
        jump docile4

    elif scoremuet >= 3:
        jump muet4
    else:
        jump docilemuetdefiant4

label defiant4 :
    g "You’re no longer in the colonies; here, you stand in the holy homeland."
    g "Here, there are rules to obey — and consequences for those who don’t."
    g "Your behavior is unacceptable. I’m issuing you a warning."
    g "Three warnings, and you’ll be expelled."
    g "Most students go through their entire schooling without receiving a single one."
    g "You’ve just arrived, and already you have one."
    g "You won’t be staying among us for long."
    i "Nice. That means I can still afford two more warnings — plenty of room for error."
    i "He clearly doesn’t like me — good. Some people are better hated from a distance."
    $ scoreblame += 1
    jump docilemuetdefiant4

label docile4 :
    g "I have a good feeling about you: you’ll know how to disappear for the sake of the group."
    g "If not, I’ll be here to set you back on the right path."
    g "Know that my door is always open to any cadet — in case of emergency."
    i "Right, if I ever need a psychopath in an emergency, I’ll know where to find you."
    p "Thank you, Headmaster."
    jump docilemuetdefiant4



label docilemuetdefiant4 :
    g "Wait here. I’ll be back."
    i "Where’s he going? Leaving me alone?"
    i "Well, I suppose that means there won’t be any welcome party..."
    i "All the better — I’d rather this tête-à-tête was over."

    #ACTE 5
    #Scène 2 (interne)
label a1s2 :
    i "I’m alone in the office. It’d be a shame not to take advantage of that..."
    i "The air smells of dust and leather. Every piece of furniture feels like part of a stage, deliberately arranged."

    menu:
        "\[BOOKSHELF] Search the bookshelf":
            jump bibliotheque

        "\[TRASH CAN] Search the trash can":
            jump poubelle

        "\[DESK] Search the desk":
            jump bureau

label bibliotheque :
    i "I walk up to the bookshelf and take a quick look at the shelves."
    i "Propaganda manuals, rewritten history books, dictionaries thick with dust. Not a single novel, not a single poem."
    i "Here, fiction is forbidden. Only official truth has the right to exist."
    jump a4s2

label poubelle :
    i "I rummage quickly through the trash can. Nothing interesting at first glance."
    i "Just crumpled papers, scribbled notes. Maybe if I pieced them together, I’d find fragments of truth… or maybe just a grocery list."
    jump a4s2    

label bureau :
    i "I check the desk. It’s locked tight — no way to open it."
    jump a4s2
#####################3.40################## premier choix
    #ACTE 5
    #Scène 3 (interne/player/galazzo/genoveva)
label a4s2:
    scene bg bureau
    with fade
    i "The door opened with a controlled creak — a sound that stretched through the silence like a discordant note."
    i "The director had returned. His heavy footsteps echoed across the polished floor, and I tensed instinctively, as if his very presence demanded a rigid posture."
    show galeazzo neutral at left
    i "He crossed the threshold first. His face wore a strange, foolish smile — out of place, almost absurd in such a rigid setting."
    i "But when I saw her appear behind him, I immediately understood why that grin clung to his lips."
    show genoveva neutral
    i "Her. An apparition in this dusty office — a sliver of light cut against the shadowed hallway. She was beautiful enough to make your eyes ache. Beautiful enough to steal my breath."
    with dissolve
    g "Cadet [PlayerName], this is Genoveva. She’s been here for two years. She’ll show you around the complex and take you to your dormitory."
    i "Genoveva… The name echoed in my mind — almost too soft for a place this cold."
    i "Her frame was slender, her stance assured. Her eyes, a brilliant blue, seemed to pulse with a life foreign to these drab walls."
    i "And that smile… constant, enigmatic, impossible to describe. She radiated brightness — a vivid energy clashing violently with the suffocating air around us."
    i "Maybe the setting worked in her favor. The stern office, older than my grandmother (and probably sturdier), the rancid scent of wax, the director stiff as a fencepost..."
    i "And me — already drained, brooding, seeing gray everywhere. In that rotten atmosphere, her glow felt unreal."
    i "Yeah, even if it sounds cliché: she looked like an angel who’d lost her way into a torture chamber."
    g "I’m counting on you, Genoveva."
    e "Yes, Headmaster."
    g "Cadet [PlayerName], don’t forget! Discipline! Obedience! Sacrifice!"
    i "Ugh… the same words again, like a broken record. What do you even want me to say to that?"
    i "I stare straight into his eyes — the kind of look that says, 'Got it, no need to hammer it in.'"
    i "He studies me, looking unimpressed… Well. So be it. With any luck, I won’t see him again anytime soon."
    i "And if I’m *really* lucky, he’ll have a stroke tonight — alone, on the toilet — and I’ll only see him again at his funeral."
    i "I turn toward Genoveva, relieved that she, at least, will be my guide through this maze."
    i "She smiles — too sincerely for me to hold her gaze. My eyes drop to the polished floor, as if staring at the wood could keep me from burning in her light."
    i "I head for the door, heart heavier than it should be for someone just leaving an office."
    e "Good evening, Headmaster. See you later."
    i "Her voice… soft, light, almost musical. She smiled as she spoke — you could hear it. Even in such banal words, there was warmth."
    i "Yes, definitely — she stood in contrast to everything else here. Like a crack in the concrete, an opening toward a world not made of rules and ashes."
    #with fade
#######################5.40#########################
    #ACTE 6
    #Scène 1 (interne/player/genoveva)
    scene bg couloir
    with fade
    show genoveva neutral
    i "Finally outside. The air in the hallway didn’t smell any better, but I breathed as if I’d just escaped a cell."
    i "I searched desperately for something clever, something funny to say — a word to break the ice, to show I wasn’t just another pawn."
    i "But nothing came. Luckily for me, she took the lead — quicker, freer, less shaken, no doubt, by my awkward presence."
    e "So… welcome to the Center. I suppose he wasn’t exactly… welcoming to you?"
    i "Her voice was gentle, but laced with irony. Finally. Finally, someone who spoke like a human being in this place that felt like a machine."
    e "Be careful with him — he hands out punishments easily."
if scoreblame >= 1:
    jump blame1

elif scoreblame <= 0:
    jump blame0

label blame0:
    p "Thanks for the warning. I’ll try to remember that."
    jump visite_start

label blame1:
    p "Yeah, I noticed. Got myself a reprimand already — apparently there are three to collect."
    show genoveva chokbarre 
    e "You already got a reprimand?!!"
    i "She looks shocked. Her gaze shifts; the warmth in her smile vanishes, and she just stands there, frozen."
    p "Don’t worry — I’ve still got two left before they kick me out. Plenty of room for mistakes."
    e "..."
    i "Fuck. Maybe I shouldn’t have been quite so honest."
    jump visite_start

label visite_start:
    show genoveva neutral2
    i "We walk down the long corridors. The cold concrete seems to swallow our footsteps, each echo dying the moment it’s born."
    i "The ceiling hangs low. The neon lights flicker — sometimes a sharp hiss tears through the silence. The light is too white, almost sickly, painting the skin with a ghostly hue."
    i "Everything is designed to discipline. The smooth walls, the straight lines, the rhythm of the steps. Even the air feels rationed here."
    e "I’ll show you the important places. You’ll get used to it eventually."
    i "Her words clang inside my head. *Get used to it?* If I ever get used to this, it’ll mean I’ve lost an invisible war against this place."

    #ACTE 7
    #Scène 1 (interne/player/genoveva)
    scene bg cantine
    with fade
    show genoveva neutral2
    e "This is the refectory. Three meals a day, strictly on time. Never be late — the supervisors don’t like that."
    i "The room opens before me like a cathedral of metal and silence."
    i "Long tables stretch in perfect rows, identical and overpolished — like lines of soldiers, ready to chew and swallow in sync."
    i "There’s no smell of food, only a faint sting of disinfectant and iron, as if even the idea of taste had been erased."
    i "Eating here isn’t a pleasure. It’s a ritual. A machine grinding time, three times a day, flavorless and joyless."

    menu:
        "\[SHY] \"It looks... very well organized.\"":
            $ scoretimide += 1
            p "\"It looks... very well organized.\""
            e "Organized enough to kill your appetite. If you’re too late, there’s no choice left. If you’re too early, you look desperate."
            i "Her words slip out like a quiet confession. I realize she’s been through it — she knows what it’s like to be just a number in this line."
            jump visite_classes

        "\[BOLD] \"Looks more like a prison.\"":
            $ scoreaudacieux += 1
            p "\"Looks more like a prison.\""
            e "Oh, you haven’t seen the dorms yet."
            i "For a second, it seemed like she’d spoken without thinking — but no. She was too sharp for that."
            i "She steps a little closer, her hand brushing my shoulder. The gesture is light, but her gaze pierces right through me."
            e "Don’t speak too loudly. The walls keep words — and sometimes they repeat them to the wrong ears."
            i "A chill runs down my spine. This place doesn’t just cage bodies — it cages words, whispers, even thoughts."
            jump visite_classes
    #ACTE 8
    #Scène 1 (interne/player/genoveva)
label visite_classes:

    scene bg classe
    with fade
    show genoveva neutral2
    e "Here are the classrooms. Each day runs to the minute: official history, logic drills, slogan exercises… and a bit of science."
    i "The rooms are spotless, frozen in symmetry. Desks shine with polish so smooth you could see your reflection — if there were any life left to reflect."
    i "No scratches, no carvings, no messages left behind. As if every thought, every personal trace was erased the moment it appeared."
    i "Even the walls are bare — no posters, no drawings. Just the sterile emptiness of a space designed to crush distraction and individuality."
    i "Everything here screams one idea: you are not a person. You are a slot, a line, a cog."

    menu:
        "\[SHY] \"Looks... educational.\"":
            $ scoretimide += 1
            p "\"Looks... educational.\""
            e "That’s a word they’d love to hear..."
            i "She smiles, but in her eyes I see a glint of exhaustion — the kind that comes from hearing the same hollow words too many times."
            jump visite_dortoirs

        "\[BOLD] Stay silent.":
            $ scoreaudacieux += 1
            i "I stay quiet. Sometimes silence says more than any answer could."
            i "Genoveva gives me a faint smile, as if she’s guessed the weight of my thoughts — as if my silence spoke for me."
            jump visite_dortoirs

    #ACTE 9
    #Scène 1 (interne/player/genoveva)
label visite_dortoirs:

    scene bg dortoir
    with fade
    show genoveva neutral
    e "And here are the dormitories. You’ve been assigned to number four."
    i "I step inside, and the sight tightens my chest."
    i "Four beds. Perfectly aligned, identical, their sheets immaculate but devoid of warmth. No photos, no books, no personal items. Not a breath of life."
    i "The air is thick with dust and disinfectant — a sour scent that clings to the throat. It feels like a morgue dressed in white linen."
    i "A museum of order, where even breathing has to fall in line."

    menu:
        "\[SHY] Nod with a faint smile":
            $ scoretimide += 1
            i "I nod softly. Words fail me, so I offer that small gesture instead."
            i "Her answering smile is sincere, almost tender. For a heartbeat, the dorm feels a little less cold."
            jump attraction

        "\[BOLD] \"A real museum of order...\"":
            $ scoreaudacieux += 1
            p "\"A real museum of order...\""
            e "Yes. And we’re the exhibits."
            i "Her voice cracks through the air like a bitter truth. She knows it too — she’s a prisoner in this glass display."
            jump attraction

label attraction:

    p "I guess this isn’t a private room."
    e "Was it the four beds that gave it away?"
    p "I admit, that helped."
    e "You’ll be sharing with Sante, Marius, and Anteo."

    #ACTE 10
    #Scène 1 (interne/player/genoveva)
    scene bg couloir
    with fade
    show genoveva neutral2
    i "Since the beginning of this visit, we hadn’t crossed a single person — as if we were alone in the entire building."
    i "I kept trying to think of something funny to say about being just the two of us."
    i "But everything that came to mind would’ve probably earned me a slap at best."
    e "We’re almost done with the tour. Only the study room left — that’s where the others are until 7:30 p.m."
    i "Almost done. And yet, part of me wishes this corridor could stretch on forever, just so I could stay beside her a little longer."
    i "Her presence warms the cold air; her words soften the silence that crushes every other part of this place."
    i "Her eyes meet mine. Just for an instant — but in that instant, there’s more meaning than in all the director’s speeches."
    i "A faint tremor, something fragile yet stubborn, stirs within me."
    i "We take another hallway and pass several other dorms."
    e "These are the girls’ dormitories."
    p "Can I see your room?"
    i "She looks half surprised, half amused."
    e "Sure. Here it is."
    scene bg dortoir
    show genoveva neutral2
    p "It’s... very different from mine."
    e "Were you expecting pink walls?"
    p "Not exactly… but maybe a few unicorn stickers and some glitter..."
    i "She bumps my shoulder playfully. I wonder if she’s this casual with everyone..."
    
    #ACTE 10
    #Scène 1 (nterne/player/genoveva)
    scene bg couloir
    show genoveva neutral2
    e "There. You know the basics now. Classes start tomorrow."

    menu:
        "\[SHY] \"Thanks… for the tour... it really means a lot.\"":
            $ scoretimide += 1
            p "\"Thanks… it really means a lot.\""
            e "I… you’re welcome, [PlayerName]."
            i "Her words brush over me like a soft touch. I hold onto them greedily, as if tomorrow might steal them away."
            jump chapitre2fin

        "\[BOLD] \"How about meeting after curfew?\"":
            $ scoreaudacieux += 1
            $ promesse1 +=1
            p "\"How about meeting after curfew?\""
            e "…You’re brave. Or reckless. We’ll see which."
            e "Seriously though — don’t even think about sneaking out after the dorms close. You’d get expelled on the spot."
            i "Her smile widens, a spark of challenge lighting her eyes. Somehow, it makes me feel like I can breathe again for the first time since I got here."
            p "You worry too much... You’ll see when I come find you tonight."
            e "I’m serious: there are motion detectors linked to an alarm at the entrance of our corridor, and at the exit of yours. So it’s impossible to wander around."
            p "Well, when you hear the alarm, you’ll know I’m on my way."
            jump chapitre2fin

label chapitre2fin:

    i "She stops us in front of a door."
    e "This is the study room. Normally, we use it to revise. Anyway, it ends in about ten minutes, then we head to dinner."
    i "So this is where we part ways, I guess. A shame — this was nice. I wish it could’ve lasted longer."
    i "I rack my brain for something to say before she leaves, but as usual… nothing comes."
    i "She knocks, then steps inside. I follow her."
    #####################################10.00################AUDACIEUX
    #ACTE 11
    #Scène 1 (interne/player/genoveva)
    scene bg etude
    show genoveva neutral
    i "The study hall. A long, sterile rectangle saturated with oppressive silence."
    i "Dozens of cadets sit in perfect rows, heads bent over identical manuals — monks copying the same sterile prayer."
    i "The scratching of pens is mechanical, almost military. No laughter, no whispers. Just tired eyes and columns of letters being swallowed whole."
    i "A supervisor in her twenties watches over the room; her eyes catch mine for a moment before she jerks her chin toward an empty seat."
    i "Genoveva points to a table at the back, beside a student who hasn’t looked up since we entered."
    e "Sit here. We stay until seven-thirty. After that, straight to the refectory."
    i "I nod vaguely and drop my things on the dull wood. The air smells of chalk, dust, and contained sweat — as if even breathing had to stay discreet."
    i "Genoveva sits a few desks away… too far for my liking. She’s there, but unreachable — her presence diluted by distance and silence."
    hide genoveva
    i "I glance at the clock on the wall: ten minutes to dinner. Ten minutes that should fly by… but here, every second crawls like a wounded beast."
    i "And I’ve got nothing to do. No manual, no notebook, not even a pen. I’m literally trapped in boredom."
    i "To my left, my neighbor still hasn’t looked up. His hand scratches the page in a manic rhythm, as if afraid someone might snatch it away before he’s done."
    i "The paper darkens beneath his pen — smothered with formulas and slogans. I look away. His zeal makes me sick."
    i "I close my eyes for a second, hoping to escape the suffocating air. Just a few seconds of freedom…"
    i "Then suddenly, a chair scrapes across the floor, slicing through the silence. Genoveva stands up, a folder in her hands. She crosses the room with confident steps — and miraculously, she’s heading straight toward me."
    i "The papers are pressed to her chest like some precious secret."
    show genoveva neutral3
    e "Here. This is your schedule, a map of the center, and an information sheet."
    i "She hands me the papers with a discreet smile — fragile, like forbidden light in this dark place."
    e "You can give it back to me tomorrow. If you want, I can bring it to the office myself, so you don’t get in trouble."
    e "Oh, and here’s a pen, too."
    i "Her voice is low, almost a whisper, yet it feels like a breath of fresh air. For a moment, the study hall stops feeling like a prison."
    i "I take the documents, my fingers brushing against hers. Just the faintest touch… but enough to spark an unexpected warmth in this frozen world."
    i "I watch her walk back to her seat."
    hide genoveva
    i "The silence settles again — but this time, it doesn’t taste the same."
    i "I unfold my schedule."
    i "At least now I’ll know where and when I’m supposed to be. Every slot filled, no room to breathe. The days already blur together, boxed in by hours of discipline and silence."
    i "I set the sheet down, bitterness on my tongue. This is my life now: a calendar of iron, a march with no rest."
    scene bg etude
    i "Finally, the bell rings — metallic, harsh — tearing everyone from their trance."
    i "Chairs scrape the floor in perfect unison. The silhouettes rise together, like a single creature with a hundred heads."
    i "I don’t have much to pack: I shove the paper and pen into my pocket."
    i "As I step out, I spot Genoveva speaking with two boys."
    i "She gives me a quick wave to signal me over."

    
    #ACTE 12
    #Scène 1 (interne/player/genoveva/marius/anteo)
label chapitre3:

    scene bg couloir
    with fade
    show genoveva neutral at left
    i "Genoveva is talking with two boys. It doesn’t take me long to realize they’re not strangers — they’re my future roommates."
    i "They seem to know her well, judging by the easy familiarity in their looks. And here I am, pockets full of papers, face of the clueless newcomer."
    show anteo neutral at right
    show marius neutral at center
    e "This is [PlayerName]. He’ll be sharing your room from now on."
    e "[PlayerName], meet Marius and Anteo."
    m "Hey. Welcome to our luxury quarantine."
    i "Genoveva playfully pinches his arm."
    a "You’re exaggerating. At least the sheets are clean here."
    i "Marius’s tone is dry, almost mocking. Anteo seems calmer, more grounded."
    i "I can’t tell yet if I should laugh or stay quiet — but ‘luxury quarantine’ fits this place perfectly."
    e "Alright, you three will go eat together. I have to join the reception committee. We’ll see each other tomorrow."
    hide genoveva
    i "She walks away, her quick steps fading down the corridor. Already, the air feels emptier without her."
    i "Marius shoots me a sarcastic wink. Anteo just gestures for me to follow."
    jump cantine_scene

    #ACTE 13
    #Scène 1 (interne/player/marius/anteo)
label cantine_scene:

    scene bg cantine
    with fade
    i "The cafeteria. Huge, freezing, organized like a factory. Cadets march in rows, trays in hand, each swallowing their portion without a word too many."
    i "We’re served the standard plate: grey meat, boiled vegetables, and bread as hard as a shoe sole. No choice. No appetite."
    show marius neutral
    show anteo neutral at right
    m "Don’t worry, it’s always like this. The taste never changes, though the texture does — sometimes rubber, sometimes plaster."
    a "Ignore him. Eat. Otherwise, you won’t keep up with the schedule."
    i "I try a bite of the meat — pasty, flavorless, like chewing on an old rag. Even the water tastes faintly of metal."
    i "Marius snickers, clearly enjoying my grimace more than his own meal."
    p "Do you always eat off to the side like this?"
    m "Yeah. It’s quieter here. Fewer ears listening in."
    a "…And fewer elbows. Most of them crowd the middle to be seen."
    i "Their rhythm is clear: Anteo speaks in measured tones; Marius twists them into jokes. Me, I’m just a guest at their table."
    p "So… how long have you two shared a room?"
    m "Two years. Practically a lifetime, in this hole."
    a "We’ve learned to… tolerate each other. It’s easier that way."
    i "His tone is calm, but his eyes glance away for a brief second — as if that ‘easier’ hides something heavier."
    p "So it’s been just the three of you all this time?"
    m "Three, yeah."
    i "A short silence. Too short to feel natural."
    a "…There used to be a fourth. But he was transferred. Officially."
    m "Officially… right. Around here, ‘transfers’ are like miracles — you only believe them when they’re convenient."
    i "Marius pokes at his bread with his fork, flashing me a smile that’s anything but friendly."
    p "I see… So, you weren’t really expecting a new roommate, huh?"
    m "Exactly. Throws off our balance. But hey, we’ll adjust."
    a "We’ll have to."
    i "The way he says it doesn’t sound like reassurance — more like resignation."
    i "Around us, conversations die instantly whenever a supervisor passes between the tables. Roger, the dorm warden, eyes us briefly before walking on."
    m "You’ll see, Roger acts tough, but he’s not the worst. Stay quiet, and he leaves you alone."
    a "…Quiet. That’s the key word here."
    i "I keep eating mechanically, but my mind turns. They’re not openly hostile — it’s something subtler."
    i "A kind of tension, as if my presence were a grain of sand in a well-oiled machine. A machine that doesn’t need another cog."
    i "And for a second, I wonder: would they have preferred if I’d been ‘transferred’ too, before even unpacking?"
    jump tempslibre

    #ACTE 13
    #Scène 1 (interne/player/marius/anteo)
label tempslibre:

    scene bg cour soir
    with fade
    i "After dinner, we get one hour of ‘free time.’ A misleading term — it just means you’re allowed to sit in the yard or flip through manuals."
    i "The supervisors watch us absentmindedly, more interested in their own chatter. Some cadets talk in low voices; others pace in circles to fight the boredom."
    i "Marius tells a dark joke to another group. Anteo stays silent, buried in a worn-out manual."
    i "As soon as we leave the cafeteria, the air hits me — cold, damp, metallic. After the smell of food and sweat, it’s almost a relief."
    i "The courtyard stretches ahead, a vast rectangle of concrete fenced by metal grilles as tall as walls. Streetlamps cast shaky yellow halos that tremble in the breeze."
    i "Cadets move in small groups. No one lingers, no one laughs loud. Their footsteps carry fatigue."
    show marius neutral
    show anteo neutral at right
    m "Finally… air. You wouldn’t think it, but breathing outside’s a luxury here."
    i "Marius lights a clumsy hand-rolled cigarette. The sharp smell mixes with the damp air. Anteo turns his head slightly, used to the habit."
    p "You always come out here after dinner?"
    a "Whenever we can. Walking a bit before heading back to the dorm helps with the evenings."
    m "Otherwise you go straight inside, and the night feels endless. But by nine, they lock us in. No exceptions."
    i "That word — ‘locked’ — sticks with me. He says it lightly, but it lands like a hard truth."
    i "We cross the courtyard slowly. The concrete cracks under our steps. The wind rattles loose bits of wire on the fence, a soft metallic clatter repeating like a pulse."
    m "Give it a few weeks — you’ll know every crack in the ground, every door that squeaks. It’s like the place wants to carve itself into your mind."
    a "Some find that comforting. Others… suffocating."
    i "I listen, caught between both. Their tone is casual, almost friendly, but every word makes this place sound more like a prison disguised as a school."
    p "You two have been together since the start, right?"
    m "Yeah. Same room for two years. We balance each other out, I guess."
    a "Let’s say we’ve found an equilibrium. That’s survival here."
    i "An equilibrium that doesn’t seem to leave much space for a third. Their eyes meet briefly, confirming some unspoken thought."
    i "We pass near Building C. A window slams — not properly closed. A light flickers inside, faint and dying, like a last heartbeat."
    m "Look at that. Been flickering for three weeks. Nobody fixes it. As long as it doesn’t mess with discipline, they let everything rot."
    a "Don’t mind him. Marius likes collecting details like that."
    m "You should too. It’s the details that tell the truth about a place."
    i "Silence settles again. Only a supervisor’s distant shouting breaks it — ordering a group of cadets to move faster."
    i "My eyes drift to the tall fences crowned with barbed wire. Beyond them, the evening sky is a deep, starless blue — as if even the night refuses to pierce this place."
    p "It’s always this… quiet in the evenings?"
    m "Quiet, yeah. But not peaceful."
    a "You’ll get used to it. Everything here’s a matter of habit."
    i "That word again — habit. As if the place were built to grind us down until nothing surprises us anymore."
    i "A whistle suddenly cuts through the air. Instantly, every group quickens their pace. Anteo straightens, alert."
    a "That came from Block B. Time to head in."
    m "Come on, rookie. No point testing their patience on your first night."
    i "I follow them. Marius walks with lazy strides, Anteo with rigid precision. I stay slightly behind."
    i "Their shadows stretch long on the wall — side by side. Mine lags behind, slightly offbeat, like it hasn’t found its place yet."

    #ACTE 14
    #Scène 1 (interne/player/marius/anteo/sante)
label dortoir_scene:

    scene bg dortoir
    with fade
    show marius neutral at left
    show anteo neutral at right
    show sante neutral at center
    i "Dorm room number four. Four beds, four cadets. Tonight, we’re finally all here — Sante’s lying on his bed, distant, eyes buried in his notebook."
    i "I drop my things on the only empty bed. The silence is heavy, almost oppressive. Marius is the first to break it, a grin already in place."
    show marius happy
    m "Well, [PlayerName], lucky you — you landed in the best room in the block."
    m "I handle the jokes."
    show anteo neutral
    m "Anteo’s the serious one."
    show anteo annoyed
    a "\"…\""
    show sante neutral
    m "And Sante… well, Sante doesn’t talk much."

    show sante neutral
    s "\"I speak when it is useful.\""
    i "His voice is deep, steady. He hasn’t looked up from his notebook once, pen moving calmly across the page."
    i "A quiet type — probably sees more than he says."
    p "\"So… I guess I’ll have to find my place in the equation, huh?\""
    i "A pause follows. Not hostile, exactly — more like everyone’s taking my measure."
    show marius neutral
    i "Marius flops onto his bed with a small laugh."
    show anteo neutral
    i "Anteo folds his arms, eyes on me, weighing every word."
    i "Sante keeps writing, though I can tell he’s listening to every sound."
    show marius happy
    m "Don’t worry, you’ll catch on quick. Just gotta learn to roll with it… and survive the terrible jokes I’m gonna throw your way."
    show anteo annoyed
    a "Or learn to ignore them."
    show marius surprised
    m "Oh come on, Mister Serious!"
    show sante neutral
    s "\"…\""
    i "A laugh escapes me. The tension loosens a bit, though the quiet quickly seeps back in."

    #ACTE 14
    #Scène 2 (interne/player/marius/anteo/sante/roger)
label roger_presentation:

    scene bg dortoir
    with fade
    show marius neutral at left
    show anteo neutral at right
    show sante neutral at center
    i "We’re still chatting when the dorm door bursts open."
    i "A broad-shouldered figure fills the doorway. Silence falls instantly."
    hide sante
    show roger neutral at center with dissolve
    r "Evening, cadets."
    r "So, how was your weekend?"
    i "The three others give vague nods — clearly a routine question. Then his eyes land on me."
    r "Name’s Roger. Night warden for the boys’ sector."
    r "My job’s simple: keep order, check roll call, and make sure none of you do anything stupid. But if you try… I’ve got zero patience."
    i "His voice is deep but uneven, like he’s repeating a speech he’s practiced. There’s an awkwardness to him — more nervous than menacing."
    show marius smirk
    m "Charming…"
    show anteo annoyed
    a "Shut up, Marius."
    hide roger
    show sante neutral
    s "He said the exact same thing the first time we met him."
    hide sante
    show roger neutral
    r "Hey, come on, guys…"
    i "He muttered that almost apologetically. Clearly, Roger wasn’t the authoritarian type — a good guy, just in the wrong job."
    r "Besides… I think the director’s still around tonight."
    i "The way he said it — like a secret that slipped out — made it sound like the idea scared him more than it did us."
    hide roger
    show sante neutral
    s "No, he left. I was with him earlier, helping prepare for the Admiral’s visit next week."
    hide sante
    show roger neutral
    i "Roger suddenly looked relieved, as if he’d just dodged an invisible trap."
    r "You’ll have plenty of chances to prove yourselves soon. But not at night. After lights-out, no one moves. Understood?"
    p "\"Understood.\""
    r "Good. I wish you all a quiet night. And remember… my eyes never really sleep."
    i "He scans each of us in turn, as if memorizing our faces. Then, without another word, he heads for the door."
    i "Before closing it, he calls out:"
    r "Lights out in ten minutes!"
    hide roger
    i "Intrigued by what Sante said, I turn to him."
    p "\"Didn’t see you in the cafeteria… Where were you?\""
    show sante neutral
    s "With the director. We were preparing for the Admiral’s arrival. I ate later."
    i "He says it casually, like it’s nothing. But the Admiral — he’s basically the head of government."
    p "\"And what exactly does ‘preparing’ mean?\""
    s "Drafting speeches. Making sure the protocol’s airtight."
    i "Marius and Anteo both stay silent, like my questions have wandered somewhere they’d rather avoid."
    p "\"Genoveva’s involved too, right?\""
    i "I tried to sound detached, but the question mattered more than I wanted to admit."
    s "Yes. Her, the director, and his assistant."
    i "The silence that follows feels heavier than before. Even the walls seem to listen."
    jump dortoir_confession



    #################
label dortoir_confession :

    scene bg dortoir
    with fade
    show marius neutral at left
    show anteo neutral at right
    show sante neutral at center

    i "The quiet settles again after Roger leaves. Only the faint hum of the ceiling lights fills the room."
    i "Marius stretches out on his bed, arms behind his head. Anteo methodically folds his clothes. Sante keeps writing, unbothered."
    i "I feel out of sync with their calm — like everything here moves at a rhythm I haven’t learned yet."
    m "So, rookie… what’d you do to end up here?"
    i "The tone was light, but the question wasn’t. Anteo looks up, curious. Sante stops writing, though he doesn’t lift his head."
    p "I didn’t exactly choose to be here."
    m "Yeah, no one does. But there’s always a story. A fight? A sabotage? Overprotective parent?"
    p "My father… was an officer in the Chorath colony."
    a "Chorath? The eastern front one?"
    p "Yeah. Model colony, or so they said — until they found a flaw."
    i "I pause. My hands clench without realizing it."
    p "My father chose to… disappear before they made him."
    i "Silence falls. The kind that weighs on your chest."
    m "Disappear?"
    p "Call it whatever you want."
    i "The word ‘suicide’ never leaves my lips. I don’t have the strength — or the desire — to give it that power."
    a "And they brought you here afterward?"
    p "Yeah. ‘Reassigned.’ A nice way to say ‘under watch.’"
    i "Marius looks away, for once uncomfortable."
    m "Fuck... That’s not your average backstory."
    s "The sins of the fathers always fall on the sons."
    i "Sante’s voice — calm, sharp. He doesn’t look at me, but the words hit dead center."
    p "I know. People make sure to remind me."
    a "You didn’t have to talk about it."
    p "If I don’t here, I never will. Might as well let you know who you’re sharing snores with."
    m "Oh, if you can’t sleep, don’t worry — Anteo sings in his sleep. Soothing as an air raid."
    a "Shut up, Marius."
    i "A choked laugh escapes me. Not because it’s funny — but because it’s that, or sink back into silence."
    i "Sante slowly closes his notebook, as if sealing an invisible chapter."
    s "Your father had courage — even if the world never gave him the chance to prove it."
    i "I can’t tell if he’s trying to comfort me or just stating a fact. Either way, his words hit deeper than I want to admit."
    p "Yeah… maybe."
    s "My father wasn’t an officer. Just a guy with a bottle glued to his hand."
    i "His tone never changes. Still calm, but every word cuts like glass."
    s "He yelled, hit, broke things. And me — stupid me — I thought it was the alcohol."
    m "Classic."
    s "Yeah. I waited for the day he’d stop. Thought things would get better. That he’d be someone again."
    i "Silence. He finally looks up, eyes fixed on some invisible point on the wall."
    s "And then one morning, he did stop. Not a drop. He woke up sober, clear, lucid."
    s "And he was still an asshole."
    i "No one laughs. Even Marius stays frozen, lips half open."
    s "That’s when I understood: the booze wasn’t the cause. It was the excuse."
    i "His fingers tighten around the notebook, crumpling the cover."
    s "Some men drink to forget they’re monsters. Mine drank to justify being one."
    a "Have you seen him since?"
    s "No. And that’s just fine with me."
    i "A heavy silence follows — not empty, though. A silence of understanding. The kind that ties people together, whether they want it or not."
    m "Damn… We should start a club. ‘Sons of Bastards Anonymous.’"
    p "Yeah. Monthly fee: one sigh and a nightmare."
    i "A small laugh breaks the quiet — fragile, genuine. It’s nothing, but it lightens the air."
    i "Sante opens his notebook again, scribbles a few words, then murmurs without looking up:"
    s "Fathers do what they want with their lives. We just make do with the ruins."
    i "His words hang in the air. For a moment, even the hum of the lights seems to stop."
    i "I finally lie back, eyes fixed on the ceiling."
    i "The dorm is silent again — but not cold. For the first time, the weight of my past doesn’t crush everything. Not tonight."
    i "Maybe here, with these three, I’ll find more than just a cell."
    i "Maybe — just maybe — a truce."

    jump nuit

    ##################

    #ACTE 14
    #Scène 3 (interne/roger)
label nuit:

    i "Ten minutes later, the door opens again — Roger appears one last time."
    hide sante
    show roger neutral
    r "Alright, boys. Lights out."
    i "The light snaps off, cutting short whatever words were left."
    i "Silence takes over, broken only by the sound of breathing."

    #ACTE 14
    #Scène 4 (interne)

    i "Lying on my bed, I stare at the ceiling. Seconds stretch on, endless."
    i "Marius’s steady snoring fills the room — he’s already out. Anteo scribbles a few last notes in his journal, face tense. Sante doesn’t move, eyes open in the dark."
    i "As for me… one thought keeps me awake: Genoveva."
    
    
    if promesse1 >= 1:
        jump okpromesse1

    elif promesse1 <= 0:
        jump pasdepromesse1

label pasdepromesse1:
    i "Eventually, my eyes close and sleep drags me under."
    jump reve_colonies


    
    
label okpromesse1 :
    i "I promised I’d see her tonight. And promises… are meant to be kept."
    i "But curfew’s in effect. Every step is a violation. Every move, a risk."
    i "I sit up quietly, heart pounding in my temples, and slip out of bed. The floor creaks under my bare feet."
########################19.40#########
    #ACTE 15
    #Scène 1 (interne/player/roger)
    scene bg couloir
    with fade
    i "The hallway is bathed in semi-darkness. The emergency lights cast a sickly glow, stretching the walls into uneasy shadows."
    i "I barely make it ten steps before a massive silhouette blocks the way — motionless, rising straight out of the dark."
    show roger neutral at center
    with dissolve
    i "Roger."
    r "Where do you think you’re going, cadet? After lights-out?"
    i "His voice rumbles through the hallway — low, heavy, almost echoing."
    p "\"I was looking for you… I started today and forgot to give a file to Genoveva. She needs it for tomorrow.\""
    show roger suspicious
    r "You'll give it to him tomorrow morning. Now I've set the alarm."
    p "\"Tomorrow she starts early — Admiral’s visit prep. I tried to catch her earlier but she was already taken elsewhere...\""
    i "Roger frowns. His gaze pierces through me, unsure. Like he’s trying to decide whether I’m lying — or whether he wants to believe me."
    r "\"…\""
    i "The silence stretches. Then he exhales sharply through his nose and gestures briskly."
    r "\"Walk.\""
    i "His heavy steps echo on the tiles. I follow, small beside him — a silent procession through the school’s sleeping corridors."
    jump rencontre_genoveva_nuit

    #ACTE 16
    #Scène 1 (interne/player/roger/unity)
label rencontre_genoveva_nuit:

    scene bg couloir
    with fade
    show roger neutral at center
    i "We wind through a maze of corridors. Each turn feels narrower than the last."
    i "The safety lights flicker now and then, throwing our stretched, distorted shadows across the walls."
    i "As we near the girls’ sector, a shrill alarm explodes suddenly. My heart stops."
    show roger annoyed
    r "Relax. That’s normal. Every night crossing gets logged."
    r "No one moves around here without being registered."
    i "He opens a metal panel on the wall. His thick fingers flip a switch. The siren cuts off instantly."
    i "But the silence that follows is even heavier — like the building itself is holding its breath."
    show unity neutral at right
    i "In front of the girls’ dorm door, a supervisor waits with arms crossed. Her eyes cut through me like blades."
    u "Roger. What’s the meaning of this?"
    r "New arrival. Forgot to hand a document to Genoveva."
    i "A long silence. Unity doesn’t take her eyes off me. Her fingers drum on her arm — counting my excuses before I even make them."
    u "\"…\""
    u "You know where her room is?"
    p "\"Yes. Thank you. I’ll only be a minute.\""
    i "She sighs — part exasperation, part fatigue — and steps aside, reluctantly."
    i "I leave Roger and Unity behind, feeling their stares on my back as I move down the corridor."
    hide unity
    hide roger
    i "The air feels different here. Doors slightly ajar, lights still on. Soft whispers and muffled laughter drift out from the rooms — nothing like the dead silence of the boys’ dorm."
    
    #ACTE 17
    #Scène 1 (interne/player/genoveva)
    scene bg dortoir
    with fade
    i "I reach Genoveva’s door. She’s already there, standing in the doorway as if she was waiting for me."
    show genoveva neutral4
    e "You… you really came. Even after lights out."
    i "Her voice barely trembles. Somewhere between surprise, discomfort… and maybe a spark she’s trying to hide."
    p "\"I made you a promise, didn’t I?\""
    e "How did you do it?"
    p "\"I pretended I needed to bring you the information sheet.\""
    i "She laughs softly, a fragile sound that fades instantly into the hallway."
    e "And you really brought it?"
    i "I search my pockets and hand her the infamous document."
    p "\"Of course. Here.\""
    show genoveva neutral7
    e "You folded it all wrong…"
    i "Her fingers slide over the crumpled paper. She smooths it open, takes a look, then frowns."
    e "But… you didn’t even fill it out!"
    p "\"You never told me to fill it out. You only told me to return it.\""
    show genoveva neutral5
    e "\"…\""
    show genoveva neutral6
    i "A small smile escapes her lips despite herself. She shakes her head, amused and exasperated all at once."
    e "Go now."
    i "Her firm tone breaks the fragile moment. But nothing erases what just happened: a promise kept, a rule broken."
    i "In this academy made of walls and regulations, keeping one’s word feels almost like an act of rebellion."
    i "And behind her shy look, I think I made her smile."

    #ACTE 18
    #Scène 1 (interne/player/roger/unity)
    scene bg couloir
    with fade
    show roger neutral at center
    show unity neutral at right
    i "I rejoin Roger and Unity, breath still unsteady."
    p  "\"It’s done. Thanks.\""
    r "Good. End of exchange. Back to the dorm."
    jump retour_dortoir


    #ACTE 19
    #Scène 1 (interne)
label retour_dortoir:

    scene bg dortoir nuit
    with fade
    i "Back in the dorm, I slip beneath the sheets without a sound. My roommates are asleep… or pretending."
    i "Sheets rustling, slow breathing… a strange improvised family."
    i "I finally close my eyes, my heart still racing from the nightly escape."
    jump reve_colonies

label reve_colonies:
    play music "audio/3.mp3"
    scene black
    with fade
    window hide
    $ renpy.pause(1)
##############################################22.10##############
    i "Sleep drags me out of the dorm. The steady breathing around me disappears… replaced by a silence without end."
    i "A smell returns. Hot iron. Wet ashes. The air is heavy, like each breath costs blood."
    i "I’m in a narrow street, walls leaning like exhausted giants. But this street… I know it. It leads nowhere."
    i "Windows are eyes, staring, judging. Behind them, children bump against the glass without a sound. Their mouths open… but no scream comes out."
    i "I reach out to one of them. My palm sticks to the window. The cold bites through me. The child smiles. And the smile is mine — younger, hungrier."
    i "A whistle blows. Sharp. Cutting. The scenery trembles. The walls bend, the street stretches like an endless scar."
    i "Far away, a flag waves. Black, streaked with red cracks dripping like still-warm blood."
    i "A voice calls: “Cadet!” No… that’s not it. The word shifts, distorts. “Slave… prisoner… vermin…” Each syllable hits my neck like a hammer."
    i "I try to answer, but my tongue is heavy. It clings to my palate like lead."
    i "The sky is pale, sunless, crushing me downward. I collapse to my knees."
    i "A child walks past. He holds a metal box. Each step tolls like a funeral bell. He opens it… and flies pour out. No food, no treasure. Just black wings filling the air."
    i "I close my eyes but still see. Always this street. Always these fences. Behind them, silhouettes stand like tombstones. They march in cadence. No mistakes. No hesitation."
    i "I recognize their faces: comrades from before. Alive? Dead? Their eyes are empty, but I know they once knew me."
    i "A figure steps forward. Tall. Authoritative. Its face is blurred, veiled in white. But when its hand rises, everything stops. Silence shatters into a thousand shards."
    i "That hand points at me. A giant accusing finger nails me to the ground."
    i "“You.”"
    i "The word echoes like an order and a sentence. My chest tightens. I want to run, but my legs are shackled."
    i "The pavement boils. Words carve themselves in stone: Discipline. Obedience. Sacrifice. They burn like embers."
    i "I scream. My voice echoes, distorts, becomes a thousand voices screaming at me. Repeating my own words — changed into prayers, into slogans."
    i "Everything burns. The black flag ignites. The silhouettes melt like wax. The children behind the windows shatter into glass shards that pierce my skin."
    i "I run. But each step brings me back to the same place. The street. Always the street. The fences. The walls. The eyes."
    i "Chains rattle. I look down. My wrists are bound. But they are not my hands: they are a child’s hands. My child self. I am a prisoner of myself."
    i "The sky opens. Not into light. Into a void. A black maw, wide and starving, swallowing me whole. I fall. I fall without end."
    i "And when I think I reach the ground…"

    scene bg dortoir nuit
    with fade
    play music "audio/4.mp3"

    i "…my eyes snap open in the darkness of the dormitory."
    i "It takes me a few seconds to realize I’m still in this damn place."
    i "The breathing of my roommates is still there. But my heart is pounding hard, like it’s trying to break my ribs."
    i "Dream. Memory. Doesn’t matter. It clings to my skin like a burn."
    i "I’ve sweated so much the sheets and the mattress are damp."
    i "I struggle to fall back asleep in this wet bed."
    ############24.15####################

    scene bg lundi
    centered "{size=+50}{b}MONDAY\n\nWATER{/b}{/size}"
    pause 
    jump reveil

    #ACTE 20
    #Scène 1 (interne/player/roger/unity)
label reveil:

    scene bg dortoir matin
    with fade
    i "A metallic noise shakes my dreams. The bell. Its relentless hammering echoes through the dorm walls."
    i "My eyes barely open: the dorm is already in motion."
    i "Marius jumps out of bed grumbling, Anteo neatly folds his stuff, and Sante — surprisingly lively — is already up, sheets tight as a drum."
    show marius neutral at left
    show anteo neutral at right
    show sante neutral at center
    m "Come on, recruit! This isn’t a hotel, and the sun waits for no one."
    a "If you miss roll call, it’s cleaning duty. Trust me, better run now."
    s "Six sharp. Same every day."
    i "I sit up, still numb. My movements are hesitant, clumsy. Theirs are already automatic."
    i "A sharp whistle pierces the hallway. No time to dawdle."
    jump petit_dej

    #ACTE 21
    #Scène 1 ((interne/player/marius/anteo/sante)
label petit_dej:

    scene bg cantine
    with fade
    i "The cafeteria echoes with clattering trays and tired voices. An endless line of cadets shuffles forward in relative silence, each holding a metal tray."
    i "Breakfast is simple: dry bread, an apple, a bowl of hot porridge. Nothing more."
    show marius neutral at left
    show anteo neutral at right
    show sante neutral at center
    m "Ah, the legendary porridge. If it had any taste, we’d almost be happy."
    a "Stop complaining. It’s nourishing, that’s enough."
    s "Eat. The day will be long."
    i "Around us, dozens of cadets gulp in silence. Some whisper, others stare into their bowls, lost somewhere far away."
    i "I lift my eyes discreetly, searching for a face among the crowd: Genoveva."
    i "Dozens of identical uniforms, but not hers. I insist, scanning every table… She’s not here, or I missed her."
    i "A sting of disappointment hits my stomach harder than the porridge."
    i "A supervisor walks between the tables, sharp gaze scanning us. No time to linger: the 7:15 bell rings in the distance."
    jump ceremonie

    #ACTE 22
    #Scène 1 (interne/player/genoveva/aumonier)
label ceremonie:

    scene bg cour matin
    with fade
    i "At 7:30 sharp, the cadets gather in the courtyard. Perfect lines stretch out, rigid like stone columns."
    i "But me… I’m a few seconds late. My footsteps echo through the frozen courtyard, every stare weighing on me."
    i "Supervisors shoot me sharp looks, but say nothing. I slip into the end of an open rank."
    show genoveva lundimatin at left 
    i "Chance — or providence — puts me right next to her. Genoveva."
    i "She turns her head slightly, surprised to see me. Her eyes catch mine for a fraction of a second before she looks straight ahead again, flawless posture."
    i "A bitter smile threatens to rise. Even buried in this crowd, her presence cracks the illusion of perfect uniformity."
    i "Supervisors stand like statues on the sides. On a makeshift podium, the director adjusts his crackling microphone."
    show galeazzo neutral at right
    g "Cadets, raise your heads. Today, as yesterday, we honor those who came before us."
    i "A chaplain steps forward, wrapped in a dark cassock. His deep voice rises like a sermon."
    show Gasparri neutral at center
    o "Let us pray for our soldiers. For those who still serve, and for those who have fallen."
    i "A total silence falls. Hundreds of heads bow in unison, like a perfectly oiled machine."
    i "Genoveva lowers her head, her hair brushing her cheek. For a second, I swear her arm brushes mine."
    e "Hold my hand."
    p "\"…What?\""
    i "My heart skips a beat. I must have imagined that. There’s no way she said that. And yet my ears burn."
    i "Maybe she was talking to someone else? I sneak a glance at her."
    e "Take my hand."
    i "This time, I’m sure of it. My brain freezes. Impossible… Worst timing ever for that kind of phrase."
    i "Only logical explanation: I misheard."
    p "\"What did you say?\""
    i "Her lips move again. Her whisper distorts in the murmur around us."
    e "Take the five sausages sticking out of my sleeve."
    p  "\"…Huh?!\""
    i "I blink. The image is absurd. My mind glitches somewhere between solemn prayer and ridiculous nonsense."
    i "And yet, she raises her hand slightly toward mine."
    i "I stay frozen, like an idiot. So she takes the initiative and gently presses her palm to mine."
    i "Her hand is warm, firm. And then I notice: all around us, cadets are already holding hands in silence."
    i "It was just the ritual, for this stupid prayer. Nothing else."
    i "I feel stupid, cheeks burning. How could I think it was… something else?"
    o "May they find strength in their duty, and peace in their sacrifice."
    i "I lower my eyes like the others, not out of faith — just to avoid attention."
    i "The scene strikes me as absurd: children forced to mutter to an empty sky in the name of a state-god fused with war."
    i "I don’t believe in these prayers. Not in flags or uniforms either. The only transcendence I trust is the one you steal from life with your own hands."
    i "They mix incense with gunpowder, faith with rifles. A mass where saints are replaced by generals and the altar smells like rust."
    i "Every ‘amen’ sounds like an order. Every hymn like a reminder: obey, serve, die if required."
    i "If that’s their god, I’d rather have nothing. The void asks for nothing and sends no one to the slaughterhouse."
    i "And yet… Genoveva’s hand, warm in mine, shakes my certainties. A real bond — one no oath can erase."
    i "To my left, she stands perfectly still, her face serene, almost devoted. I wonder if she truly believes all this crap… or if she’s acting too."
    i "Ahead, a cadet mumbles the words, drowned out by the solemn chant rising around us."
    i "Voices climb, heavy and powerful, into the cold morning air. A song of iron and faith — but I only hear noise."
    o "Remember: you are not just students. You are the future. The honor and survival of our nation already rest upon your shoulders."
    i "A final silence weighs like a slab of stone. Then the bell rings, marking the end of the ceremony and the beginning of classes."
    jump lundi8h
 
label lundi8h :
    scene bg classe

    i "The metallic bell still rings in my ears. The cadets freeze, each glued to their polished desk like a ceremonial weapon."
    i "The neon lights buzz, spreading a sickly light that gives every face a spectral pallor."
    i "The door opens. A man walks in. Not a supervisor, not a soldier: the civics teacher."
    show gentile neutral at center
    i "Dark suit, sharp gestures, methodical gaze. No shouting, no brutality... but something far more unsettling: a machine-like calm."
    i "He places a folder on his desk, takes time to align it perfectly with the edges, then finally looks up."
    n "Cadets. Welcome to the subject that will make you more than individuals. Here, you will learn to be citizens. And a citizen... is not a person. It is a role."
    i "He lets silence fall. His words seep in like black ink."
    n "History has proven that societies fail when everyone believes they are free to follow their whims. Freedom is not the absence of chains."
    n "Freedom is understanding which chains we need."
    i "With a brief, almost imperceptible smile, he writes three words on the board:"
    "Service – Harmony – Continuity."
    n "You may have heard other versions… discipline, obedience, sacrifice. But remember this: it’s not about blind obedience. It’s about accepting that the State thinks better than you."
    i "He walks slowly between the rows, hands clasped behind his back. Each step echoes like a metronome."
    n "Tell me, cadet..."
    i "He stops abruptly in front of a random student, staring without blinking."
    n "If your neighbor cheats on an exam, what do you do?"
    ########################29.00##################################
    b "...I'm reporting it, sir."
    i "A sharp nod."
    n "Correct. The fault of one becomes the fault of all. Tolerance is a poison. It destroys unity. By reporting him, you save him. And you save the Nation."
    i "He resumes walking. This time, he stops near me."
    i "His eyes pierce into mines."
    n "And you, Cadet [PlayerName]? What is a personal truth worth... against the collective truth?"
    i "Silence thickens. The entire room holds its breath. Or maybe just me..."
    
    menu:
        "\[OBEDIENT] \"The collective truth is the only one that matters.\"":
            i "The teacher nods, satisfied."
            n "Good. You understand."
            jump lundi8h2
        "\[MISTRUSTFUL] \"A truth that must be imposed has no force.\"":
        #"\[DÉFIANT] \"Une vérité qu’on doit imposer n’a aucune force.\"":
        # $ scoreaudacieux += 1
            i "A shudder runs through the room. No one breathes. The professor stares at me, motionless."
            n "Interesting."
            i "His smile is not human. It looks like a crack in a wall."
            n "So you think that the truth should convince, rather than constraint?"
            i "I don't answer. His gaze is searching for a flaw in me, ready to burst through it."
            n "I take note of your… philosophy."
            i "He says this as one notes a crime."
            n "I hope for you that the Nation will never have to impose its truth... on someone who thinks like you."
            i "His voice doesn't rise a single note. Yet the threat slips through the air, soft and icy."
            jump lundi8h2


label lundi8h2 :
    i "The teacher opens his folder and takes out a thin grey booklet: The Citizen Contract. Each cadet receives a copy, placed before them like a freshly issued weapon."
    n "Read Article One."
    i "Pages rustle. Words snap: “Every citizen belongs first to the Nation, before belonging to themselves.”"
    i "Nation and State were, here as everywhere in the country, blended together — and over time, the two terms had become synonyms for most people."
    n "Some think this sentence harsh. But consider: if you were alone, without the Nation... who would feed you?"
    n "Who would protect you? Who would write your story? No one. You would be a shadow. So don’t fear being a cog: it’s the only way to exist."
    i "He pauses, seemingly benevolent."
    n "Tomorrow, you will recite this article by heart. Not to please me. But to learn to breathe with the others."
    i "The bell rings again. The cadets rise in perfect sync, one single body."
    i "But his last words stick in your mind like a shard: “A citizen is not a person. It is a role.”"
    i "The teacher closes his folder, then raises a sharp hand."
    n "Sit. Do you think a citizen may abandon their duty at will? The bell is a tool... not a master."
    i "A shiver runs across the room. Everyone sits back down, rigid."
    i "He pulls out a sheet from his folder. On it, a single word written in red: “Treason.” He holds it up, then pins it onto the board with a metal magnet."
    n "Let’s consider a practical case. Imagine a citizen refuses to serve. Disobeys orders. What should we do?"
    i "A murmur spreads. Eyes meet, then look away. No one dares speak."
    i "The teacher fixes a student in the front row."
    n "You."
    i "The student swallows hard."
    b "He must be punished, sir."
    n "Correct. But punishment alone is not enough. A failing citizen endangers the trust of the whole."
    i "He slowly turns towards the class."
    n "So, I ask you: what does treason deserve?"
    
    menu:
        "\[OBEDIENT] \"Treason must be erased. By example.\"":
            i "The teacher smiles. Good. Example purifies. Punishing one protects a thousand."
            n "Good! You understood"
            jump lundi8h3
   

        "\[MISTRUSTFUL] \"Maybe he had his reasons. Understand first, punish after.\"":
            i "A dry, joyless laugh escapes the teacher."
            n "Understand, you say? A dangerous idea. To understand is to excuse. And to excuse is to open the door to a thousand betrayals."
            jump lundi8h3
    

label lundi8h3:
    i "The teacher picks up the chalk and writes on the board:"
    "“Tolerance breeds rebellion.”"
    n "Write this down. Copy it ten times tonight before bed. Not as homework… but as a vaccine."
    i "He puts his folder away slowly and concludes:"
    n "Remember what we did today. Civics is not theory. It is training. Discipline of the mind. You will learn to think correctly. And thinking correctly... means thinking like the Nation."
    i "A final silence. Then, almost softly:"
    n "A citizen who hesitates is already an enemy."
    i "The bell rings once more. This time, he gives a curt nod:"
    n "Now, you may leave."
    i "Desks scrape in unison as cadets leave the room in compact silence. The word “Treason” in red remains behind, a scar that refuses to fade."

    scene bg couloir
    i "The bell still echoes in the halls as cadets pour into the corridor. Footsteps strike the ground like a single tide. No one speaks too loudly. Silence lingers, as though any word might be repeated to the wrong ears."
    i "To my right, Marius chuckles softly, hands in his pockets."
    show marius neutral at left
    m "Well... first class and we’re already learning to punish our own shadows."
    i "He imitates the teacher’s tone in a low voice:"
    m "“A citizen who hesitates is already an enemy...”" #changer color pour celle du prof
    i "Marius gives you an ironic wink."
    m "Bet he practices that in front of the mirror every morning."
    i "In contrast, Anteo shakes his head. His tone is calm, but firm."
    show anteo neutral at right
    a "You joke, but think. If a monitor heard you, you’d already be in a report. Every word matters here."
    i "Marius shrugs, feigning nonchalance."
    m "Yeah, yeah. We’ll see."
    i "Behind him, Santé walks silently, his notebook clutched to his chest. His eyes are fixed on the ground, but his deep voice can be heard."
    show sante neutral at center
    s "He’s right about one thing. Silence is dangerous. Not for us... but for the one who keeps it."
    s "It’s like offering your throat to the blade."
    i "His harsh tone chills the air."
    i "Then Genoveva, who was walking slightly ahead, turns to me. Her blue eyes catch mine."
    hide sante 
    show genoveva neutral at center
    e "And you, [PlayerName]? What do you think?"
    i "Her look is serious, but a spark of irony dances there, trying to pierce your façade."
    menu:
        "\[SHY] \"\"I think he’s right. Without discipline, everything collapses.\"":
            $ scoretimide += 1
            p "I think he’s right. Without discipline, everything collapses."
            i "Genoveva nods, though her eyes dim slightly."
            m "Oh, great... another model soldier."
            jump  lundi8h4

        "\[MISTRUSTFUL] \"\"It was brainwashing. They want us to turn on each other.»":
            p "It was brainwashing. They want us to turn on each other."
            $ scoreaudacieux += 1
            i "A faint smile crosses Genoveva’s lips, quickly hidden."
            i "Marius bursts out laughing."
            m "Finally someone who sees!"
            i "Anteo, frown"
            a "Shut up. You never know who’s listening."
            i "Sante lifts his head, his piercing eyes fixed on mine."
            s "Those who talk too much never talk for long."
            jump lundi8h4

label lundi8h4:
    i "The group walks down the hall. Behind Marius’s muffled laughter, Anteo’s warnings, Sante’s silence, and Genoveva’s eyes..."
    i "one truth becomes clear: everyone has their own way of surviving here."

    label end_demo:
    scene black with fade
    centered "DEMO ENDED\n\nThank you for playing this first version of the game.\n The adventure has only just begun.\n\n To follow the development and discover the release date: \n www.copyleftfactory.com \n\n See you soon for the rest."
    return





